## 架构

![架构](assets/1538012041465-7092486a-0e32-409e-a63d-a5b804e061f2.png)

生产者将消息发送到broker,exchange根据消息头中的路由key(routing key)到路由表里查询对应的binding，然后把消息发送到对应的message queue，消费者从queue中读取消息。


## 一些概念
- Broker: 简单来说就是消息队列服务器的实体。
- Vhost： 可以先不深究，固定为 /
- Connection：即连接， 与你日常理解的连接没有什么不同，比如 redis的连接，mysql的连接
- Channel：即通道， 可以理解为一个连接中的子通道，想象一条高速公路，可能是 4车道的，也可能是 8 车道的，这些车道就是 Channel。
- Exchange： 交换机，如果你知道交换机设备的话，它的原理跟交换机是基本一样的。
交换机必须知道如何处理它接收到的消息，是应该推送到指定的队列还是是多个队列，或者是直接忽略消息。
- routingkey： 用来绑定交换机和队列的一个字符串。发送消息时需要指定 routingKey, 绑定了此 routingKey的队列将接收到此消息。
- Queue: 消息队列载体，用来存储消息。
- binding: 交换器和队列之间的联系我们称之为绑定（binding）,可以简单理解为：这个队列（queue）对这个交换机（exchange）的消息感兴趣。

## Exchange 类型

- Direct exchange

Direct exchange 完全根据 key 进行投递，只有 key 与绑定时的 routing key 完全一致的消息才会收到消息。

Direct Exchange 是 RabbitMQ 默认的 Exchange，完全根据 RoutingKey 来路由消息。设置 Exchange 和 Queue 的 Binding 时需指定 RoutingKey（一般为 Queue Name），发消息时也指定一样的 RoutingKey，消息就会被路由到对应的Queue。

![](assets/img004.png)

- Fanount exchange 

Fanount 完全不关心 key，直接采取广播的方式进行消息投递，与该交换机绑定的所有队列都会收到消息
![](assets/img005.png)

- Topic exchange

Topic exchange 会根据 key 进行模式匹配然后进行投递，与设置的 routing key 匹配上的队列才能收到消息。

- Headers exchange

Header exchange 使用消息头代替 routing key 作为关键字进行路由，不过在实际应用过程中这种类型的 exchange 使用较少。